import java.awt.*;
import java.awt.event.*;

public
class MyDialog extends Dialog implements WindowListener
{
  String text;
  FontMetrics fontMetrics;
  int width = 160, height = 100;
  public MyDialog (Frame parent , String title , String text)
  {
    super(parent, title, true);
    addWindowListener(this);
    setSize(width, height);
    this.text = text;
    setVisible(true);
  }
  public void paint(Graphics gDC)
  {
    int strWidth, strHeight, xPos, yPos;
    fontMetrics = gDC.getFontMetrics();
    strWidth = fontMetrics.stringWidth(text);
    strHeight = fontMetrics.getHeight();
    xPos = (int) (width - strWidth) / 2;
    yPos = (int) (height - strHeight) / 2 + getInsets().top;
    gDC.drawString (text, xPos, yPos);
  }
  public void windowClosing(WindowEvent e)
  {
    dispose();
  }
  public void windowClosed(WindowEvent e){}
  public void windowOpened(WindowEvent e){}
  public void windowIconified(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowActivated(WindowEvent e){}
  public void windowDeactivated(WindowEvent e){}
}
